<?php
	 
	error_reporting(0);
	
	function PHP_Secure($string, $censored_words = 1) {
		global $con,$config;
		$string = trim($string);
		$string = htmlspecialchars($string, ENT_QUOTES,'UTF-8');
		$string = str_replace('\r\n', " <br>", $string);
		$string = str_replace('\n\r', " <br>", $string);
		$string = str_replace('\r', " <br>", $string);
		$string = str_replace('\n', " <br>", $string);
		$string = str_replace('&amp;#', '&#', $string);
		$string = stripslashes($string);
		if ($censored_words == 1) {
			 
			@$censored_words = @explode(",", $config['censored_words']);
			foreach ($censored_words as $censored_word) {
				$censored_word = trim($censored_word);
				$string        = str_replace($censored_word, '****', $string);
			}
		}
		return $string;
	}
	
	function PHP_file_size($url){
		$headers = get_headers($url, 1);
		if (is_array($headers) && count($headers) > 0) {
			$size = $headers['Content-Length'];
			if (is_array($size)) {
				foreach ($size as $value) {
					if ($value != 0) {
						$size = $value;
						break;
					}
				}
			}
			 
			return $size;
			
		} else {
			return "unknown";
		}
	}
	
	function PHP_clear_string($data){
		$data = stripslashes(trim($data));
		$data = strip_tags($data);
		$data = htmlspecialchars($data, ENT_QUOTES, 'UTF-8');
		return $data;
	}

	function PHP_xss_clean($data){
		$data = htmlspecialchars($data, ENT_QUOTES, 'UTF-8');
		return $data;
	}
	
	function sanitize($string, $forceLowercase = false, $anal = false){
		$strip = array("~", "`", "!", "@", "#", "$", "%", "^", "&", "*", "(", ")", "_", "=", "+", "[", "{", "]",
			"}", "\\", "|", ";", ":", "\"", "'", "&#8216;", "&#8217;", "&#8220;", "&#8221;", "&#8211;", "&#8212;",
			"â€”", "â€“", ",", "<", ".", ">", "/", "?");
		$clean = trim(str_replace($strip, "", strip_tags($string)));
		$clean = preg_replace('/\s+/', "-", $clean);
		$clean = ($anal) ? preg_replace("/[^a-zA-Z0-9]/", "", $clean) : $clean;
		$clean = ($forceLowercase) ?
			(function_exists('mb_strtolower')) ?
				mb_strtolower($clean, 'UTF-8') :
				strtolower($clean) :
			$clean;
		$specialChars = "\x00\x21\x22\x24\x25\x2a\x2f\x3a\x3c\x3e\x3f\x5c\x7c";
		$clean = str_replace(str_split($specialChars), '_', $clean);
		$clean = substr($clean, 0, 40);
		$clean = mb_convert_encoding($clean, 'UTF-8', 'UTF-8');
		return $clean;
	}
	
	$headers_url = $_GET["url_video"];//-- id with the video link
	$headers_title = $_GET["title"];//-- id with the name of the video	
	
	//-- with the base64() function we use it to avoid errors of special carat
	$url = base64_decode($headers_url);
	$title = str_replace(" ", "_", $headers_title);
	$title_none = "video_none";
	//-- with this function is to know the format of the video
	preg_match("/.(3gp|3GP|mp4|MP4|flv|FLV|avi|AVI|webm|WebM|wmv|WMV|mov|MOV|h264|H264|mkc|MKV|3gpp|3GPP|mpegps|MPEGPS|mpeg4|MPEG4|gifv|GIFV|jpg|JPG|jpeg|JPEG|png|PNG|icon|ICON|gif|GIF|mp3|MP3)/", PHP_Secure($url), $check);
	if (@$check[1] == 'H264'&&'h264'){
		$Formats = 'mp4';
	}else if(@$check[0] == null){	
		$Formats = 'mp4';
	}else{	
		$Formats = $check[1];
	}

	//-- here ends the name of the video with the format
	$fileName = PHP_clear_string(PHP_xss_clean($title));
	$fileName = html_entity_decode($title, ENT_QUOTES, "UTF-8");
	$fileName = ''.utf8_encode($fileName).'.'.$Formats.'';
	
	$context_options = array(
        "ssl" => array(
            "verify_peer" => false,
            "verify_peer_name" => false,
        ),
    );
	
	if(!empty($url)){
		//-- Define headers
		header("Cache-Control: public");
		header("Content-Description: File Transfer");
		header("Content-Disposition: attachment; filename=".utf8_decode(mb_substr($fileName.'.mp4', 0, 400, "UTF-8"))."");//-- fileName
		header("Content-Type: video/$Formats charset=utf-8");
		header("Content-Transfer-Encoding: binary");
		header('Expires: 0');
		header('Pragma: no-cache');
		if (isset($_SERVER['HTTP_USER_AGENT']) && strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE') !== FALSE) {
			header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
			header('Pragma: public');
		}
	    $filesize = PHP_file_size($url);
		if ($filesize > 0) {
			header('Content-Length: ' . $filesize);
		}
		//-- Read the file
		//readfile($url);
		ob_clean();
		ob_end_flush();
		readfile($url, "", stream_context_create($context_options));
		exit;
	}else{
		@header("Location:./");
		exit('<meta http-equiv="Refresh" content="0;url=./">');
		echo 'error';
	}
?>
